package edu.unl.consystlab.sudokuSolver;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;


public class solverThread extends Thread{

	private constraintProblem problemToSolve;
	private forwardCheckingSearch mySearch;
	private boolean finishedSearching;
	private JLabel resultLabel;
	
	
	public solverThread(constraintProblem newProblem, JLabel newLabel)
	{
		resultLabel = newLabel;
		this.setDaemon(true);
		this.setPriority(2);
		problemToSolve = newProblem;
		finishedSearching = false;
	}
	
	public void run()
	{
		mySearch = new forwardCheckingSearch(problemToSolve);
        try {
            mySearch.solve();
        } catch (InterruptedException ex) {
            resultLabel.setText("Unknown");
            return;
        }
		finishedSearching = true;
		if(mySearch.getSolutionNum() > 50)
            resultLabel.setText("> 50");
        else
            resultLabel.setText(Integer.toString(mySearch.getSolutionNum()));
		return;
	}
	
	public int getSolutions()
	{
		if(finishedSearching)
		{
			return mySearch.getSolutionNum();
		}
		else
		{
			return -1;
		}
	}
}
